#ifndef _PLUGIN_H_
#define _PLUGIN_H_
#include "first.h"

#include "base_decls.h"
#include "plugin_config.h"


#define SERVER_FUNC(x) \
		static handler_t x(server *srv, void *p_d)

#define CONNECTION_FUNC(x) \
		static handler_t x(connection *con, void *p_d)

#define REQUEST_FUNC(x) \
		static handler_t x(request_st *r, void *p_d)

#define INIT_FUNC(x) \
		__attribute_cold__ \
		static void *x(void)

#define FREE_FUNC(x) \
		__attribute_cold__ \
		static void x(void *p_d)

#define SETDEFAULTS_FUNC   __attribute_cold__ SERVER_FUNC
#define SIGHUP_FUNC        __attribute_cold__ SERVER_FUNC
#define TRIGGER_FUNC       SERVER_FUNC

#define SUBREQUEST_FUNC    REQUEST_FUNC
#define PHYSICALPATH_FUNC  REQUEST_FUNC
#define REQUESTDONE_FUNC   REQUEST_FUNC
#define URIHANDLER_FUNC    REQUEST_FUNC

#define PLUGIN_DATA        int id; \
                           int nconfig; \
                           config_plugin_value_t *cvlist; \
                           const struct plugin *self; \
                           void *lib        /* dlopen handle */

struct plugin {
	                                                                      /* is called ... */
	handler_t (* handle_uri_raw)           (request_st *r, void *p_d);  /* after uri_raw is set */
	handler_t (* handle_uri_clean)         (request_st *r, void *p_d);  /* after uri is set */
	handler_t (* handle_docroot)           (request_st *r, void *p_d);  /* getting the document-root */
	handler_t (* handle_physical)          (request_st *r, void *p_d);  /* mapping url to physical path */
	handler_t (* handle_request_env)       (request_st *r, void *p_d);  /* (deferred env populate) */
	handler_t (* handle_request_done)      (request_st *r, void *p_d);  /* at the end of a request */
	handler_t (* handle_subrequest_start)  (request_st *r, void *p_d);  /* when handler for request not found yet */
	handler_t (* handle_subrequest)        (request_st *r, void *p_d);  /* handler for request (max one per request) */
	handler_t (* handle_response_start)    (request_st *r, void *p_d);  /* before response headers are written */
	handler_t (* handle_request_reset)     (request_st *r, void *p_d);  /* after request done or request abort */

	handler_t (* handle_connection_accept) (connection *con, void *p_d);  /* after accept() socket */
	handler_t (* handle_connection_shut_wr)(connection *con, void *p_d);  /* done writing to socket */
	handler_t (* handle_connection_close)  (connection *con, void *p_d);  /* before close() of socket */

	handler_t (* handle_trigger)         (server *srv, void *p_d);        /* once a second */
	handler_t (* handle_sighup)          (server *srv, void *p_d);        /* at a sighup */
	handler_t (* handle_waitpid)         (server *srv, void *p_d, pid_t pid, int status); /* upon a child process exit */

	void *(* init)                       (void);
	handler_t (* priv_defaults)          (server *srv, void *p_d);
	handler_t (* set_defaults)           (server *srv, void *p_d);
	handler_t (* worker_init)            (server *srv, void *p_d); /* at server startup (each worker after fork()) */
	void (* cleanup)                     (void *p_d);

	const char *name;/* name of the plugin */
	size_t version;
	void *lib;       /* deprecated; do not use */
};
typedef struct plugin plugin;

struct plugin_data_base {
	PLUGIN_DATA;
};
typedef struct plugin_data_base plugin_data_base;

#endif
